class Animator {
    blocked = true;
    fullscreen = false;

    layers = [];
    audios = [];
    layerInFocus = false;
    constructor() {
        this.portfolio = document.getElementById("portfolio");
        this.element = document.createElement("DIV");
        this.eventElement = document.createElement("DIV");
        this.portfolio.appendChild(this.element);
        this.portfolio.appendChild(this.eventElement);
        for (let i = 0; i < layers.length; i++) {
            const layer = layers[i];
            this.layers[i] = new Layer(this, layer);
        }

        this.eventElement.obj = this;
        this.eventElement.onmousemove = function (event) { this.obj.eventMove(event); };
        this.eventElement.onmouseout = function (event) { this.obj.eventBlur(); };
        this.eventElement.onclick = function (event) { this.obj.eventMove(event); };
        this.eventElement.ontouchmove = function (event) { this.obj.eventTouchMove(event); };
        this.eventElement.ontouchend = function (event) { this.obj.eventBlur(); };
        this.eventElement.ontouchcancel = function (event) { this.obj.eventBlur(); };
    }

    eventBlur() {
        if (!this.layerInFocus)
            return;

        this.layerInFocus.eventBlur();
    }

    eventMove(event = false) {
        if (!this.fullscreen)
            return;

        if (event !== false) {
            this.x = ~~(1000 * (event.offsetX / this.element.offsetWidth));
            this.y = ~~(701 * (event.offsetY / this.element.offsetHeight));
        }

        if (this.layerInFocus) {
            if (this.layerInFocus.isInside(this.x, this.y))
                return;

            this.layerInFocus.eventBlur();
            this.layerInFocus = false;
        }

        for (let i = 0; i < this.layers.length; i++) {
            const layer = this.layers[i];
            if (layer.isInside(this.x, this.y)) {
                layer.eventFocus();
                this.layerInFocus = layer;
                return;
            }
        }
    }

    eventRefresh() {
        for (let i = 0; i < this.layers.length; i++) {
            this.layers[i].eventRefresh();
        }
        for (let i = 0; i < this.audios.length; i++) {
            this.audios[i].eventRefresh();
        }
    }

    eventTouchMove(event) {
        if (!this.fullscreen)
            return;

            this.x = ~~(1000 * (event.targetTouches[0].offsetX / this.element.offsetWidth));
            this.y = ~~(701 * (event.targetTouches[0].offsetY / this.element.offsetHeight));

        if (this.layerInFocus) {
            if (this.layerInFocus.isInside(this.x, this.y))
                return;

            this.layerInFocus.eventBlur();
            this.layerInFocus = false;
        }

        for (let i = 0; i < this.layers.length; i++) {
            const layer = this.layers[i];
            if (layer.isInside(this.x, this.y)) {
                layer.eventFocus();
                this.layerInFocus = layer;
                return;
            }
        }
    }

    start(me) {
        me.hidden = true;
// exibe o botao para sair
//        me.nextElementSibling.hidden = false;
        document.getElementById('fullscreen').requestFullscreen();
        this.fullscreen = true;

        if (!this.blocked)
            return;

        this.blocked = false;
        for (let i = 0; i < this.audios.length; i++) {
            this.audios[i].unblock();
        }
    }

    stop(me) {
        me.hidden = true;
        me.previousElementSibling.hidden = false;
        document.exitFullscreen();
        this.fullscreen = false;
        // window.stopAnimation = true;
        for (let i = 0; i < this.layers.length; i++) {
            this.layers[i].eventBlur();
        }
        for (let i = 0; i < this.audios.length; i++) {
            this.audios[i].stop();
        }
        this.layerInFocus = false;
    }
}

function say(message) {
    var element = document.getElementById("message");
    element.innerHTML = message;
}

function refresh() {
    if (window.stopAnimation)
        return;
    animator.eventRefresh();
    window.requestAnimationFrame(refresh);
}

window.addEventListener("load", () => {
    window.animator = new Animator();
    window.requestAnimationFrame(refresh);
});

window.addEventListener("blur", () => {
    animator.stop();
});

