class Layer {

    stages = [
        { name: "Stop", ttl: 1, next: "Stop", focus: "Stop2PhotoForward", blur: "Stop" },
        { name: "Stop2PhotoForward", ttl: 2, next: "Photo", focus: "Stop2PhotoForward", blur: "Stop2PhotoRewind" },
        { name: "Stop2PhotoRewind", ttl: 2, next: "Stop", focus: "Stop2PhotoForward", blur: "Stop2PhotoRewind" },
        { name: "Photo", ttl: 1, next: "Photo2DrawForward", focus: "Photo", blur: "Photo2EndingForward" },
        { name: "Photo2EndingForward", ttl: 3, next: "Draw", focus: "Photo2DrawForward", blur: "Photo2EndingForward" },
        { name: "Photo2DrawForward", ttl: 3, next: "Draw2DreamForward", focus: "Photo2DrawForward", blur: "Photo2EndingForward" },
        { name: "Photo2DrawRewind", ttl: 3, next: "Photo", focus: "Photo2DrawRewind", blur: "Photo2EndingForward" },
        { name: "Draw2DreamForward", ttl: 3, next: "Dream", focus: "Draw2DreamForward", blur: "Draw2DreamRewind" },
        { name: "Draw2DreamRewind", ttl: 3, next: "Draw", focus: "Draw2DreamForward", blur: "Draw2DreamRewind" },
        { name: "Dream", ttl: 10, next: "Dream2Draw", focus: "Dream", blur: "Dream2Draw" },
        { name: "Dream2Draw", ttl: 4, next: "Draw", focus: "Dream2Draw", blur: "Dream2Draw" },
        { name: "Draw", ttl: 2, next: "Draw2StopForward", focus: "Photo2DrawRewind", blur: "Draw" },
        { name: "Draw2StopForward", ttl: 3, next: "Stop", focus: "Draw2StopRewind", blur: "Draw2StopForward" },
        { name: "Draw2StopRewind", ttl: 2, next: "Photo2DrawRewind", focus: "Photo2DrawRewind", blur: "Draw2StopForward" }
    ];



    currentStage = "stageStop";
    currentIndex = 0;
    currentTTL = 1;

    next = false;
    speed = 0.0;
    ttl = 0.0;

    photoAlpha = 0.0;
    dreamAlpha = 0.0;
    drawAlpha = 0.0;

    x1 = 0;
    x2 = 0;
    y1 = 0;
    y2 = 0;

    audioIndex = 0;
    audioList = [];

    constructor(parent, layer) {
        for (let i = 0; i < layer.audioList.length; i++) {
            const src = layer.audioList[i];
            const audio = new portfolioAudio(src);
            this.audioList[i] = audio;
            parent.audios[parent.audios.length] = audio;
        }
this.audioIndex = this.audioList.length - 1;
        this.x1 = layer.x1;
        this.x2 = layer.x2;
        this.y1 = layer.y1;
        this.y2 = layer.y2;
        this.name = layer.name;

        this.photo = document.createElement("IMG");
        this.photo.src = urlBase + layer.photoSrc + '.png';
        this.photo.alt = this.name + ' Foto';
        this.photo.style.opacity = '0.0';
this.photo.className = "hidden";
        parent.element.appendChild(this.photo);

        this.draw = document.createElement("IMG");
        this.draw.src = urlBase + layer.drawSrc + '.png';
        this.draw.alt = this.name + ' Desenho';
        this.draw.style.opacity = '0.0';
this.draw.className = "hidden";
        parent.element.appendChild(this.draw);

        this.dream = document.createElement("IMG");
        this.dream.src = urlBase + layer.dreamSrc + '.png';
        this.dream.alt = this.name + ' Sonho';
        this.dream.style.opacity = '0.0';
this.dream.className = "hidden";
        parent.element.appendChild(this.dream);
    }

    eventBlur() {
        this.changeStage("blur");
        if (this.audioList.length > 0)
            this.audioList[this.audioIndex].stop();
    }

    eventFocus() {
        this.changeStage("focus");

        if (this.audioList.length === 0)
            return;

if(this.audioList.length === 1) {
this.audioList[0].play();
return;
}

        if (!this.audioList[this.audioIndex].ended) {
            this.audioList[this.audioIndex].play();
            return;
        }

        this.audioIndex++;
        if (this.audioIndex === this.audioList.length)
            this.audioIndex = 0;

            this.audioList[this.audioIndex].ended = true;
        this.audioList[this.audioIndex].play();
    }

    eventRefresh() {
        if (!this[this.currentStage]) {
            say("stage not found " + this.currentStage);
            stop();
        }

        this[this.currentStage]();

        if (!this.next)
            return;

        this.next = false;
        this.changeStage("next");
    }

    changeStage(field) {
        if (this.currentStage === this.stages[this.currentIndex][field])
            return;

        this.currentStage = this.stages[this.currentIndex][field];
        this.currentIndex = this.findStage(this.currentStage);
        this.currentTTL = this.stages[this.currentIndex].ttl;
        this.speed = 0.01667 / this.currentTTL;
        this.ttl = 0;
        this.currentStage = "stage" + this.currentStage;
    }

    findStage(name) {
        for (let i = 0; i < this.stages.length; i++) {
            if (this.stages[i].name === name)
                return i;
        }
        say("stage not found " + name);
        stop();
    }

    isInside(x, y) {
        if (x < this.x1)
            return false;
        if (x > this.x2)
            return false;
        if (y < this.y1)
            return false;
        if (y > this.y2)
            return false;

        return true;
    }

    stageStop() {
    }

    stageStop2PhotoForward() {
if(this.photo.className === "hidden")
this.photo.className = "";
        this.photoAlpha += this.speed;

        if (this.photoAlpha >= 1.0) {
            this.photoAlpha = 1.0;
            this.next = true;
        }
        this.photo.style.opacity = this.photoAlpha.toString();
    }

    stageStop2PhotoRewind() {
        this.photoAlpha -= this.speed;

        if (this.photoAlpha <= 0.0) {
            this.photoAlpha = 0.0;
this.photo.className = "hidden";
            this.next = true;
        }
        this.photo.style.opacity = this.photoAlpha.toString();
    }

    stagePhoto() {
        this.ttl += this.speed;
        if (this.ttl >= 1)
            this.next = true;
    }

    stageDraw2DreamForward() {
if(this.dream.className === "hidden")
this.dream.className = "";
        this.dreamAlpha += this.speed;

        if (this.dreamAlpha >= 1.0) {
            this.dreamAlpha = 1.0;
            this.next = true;
        }
        this.dream.style.opacity = this.dreamAlpha.toString();
    }

    stageDraw2DreamRewind() {
        this.dreamAlpha -= this.speed;

        if (this.dreamAlpha <= 0.0) {
            this.dreamAlpha = 0.0;
this.dream.className = "hidden";
            this.next = true;
        }
        this.dream.style.opacity = this.dreamAlpha.toString();
    }

    stageDream() {
        this.ttl += this.speed;
        if (this.ttl >= 1.0) {
            this.ttl = 1.0;
            this.next = true;
        }
        this.dream.style.filter = 'hue-rotate(' + this.ttl.toString() + 'turn)';
    }

    stageDream2Draw() {
        this.dreamAlpha -= this.speed;

        if (this.dreamAlpha <= 0.0) {
            this.dreamAlpha = 0.0;
this.dream.className = "hidden";
            this.next = true;
        }

        this.dream.style.opacity = this.dreamAlpha.toString();
    }

    stagePhoto2DrawForward() {
if(this.draw.className === "hidden")
this.draw.className = "";
        this.drawAlpha += this.speed;

        if (this.drawAlpha >= 1.0) {
            this.drawAlpha = 1.0;
this.photo.className = "hidden";
            this.next = true;
        }

        this.photoAlpha = 1.0 - this.drawAlpha;
        this.photo.style.opacity = this.photoAlpha.toString();
        this.draw.style.opacity = this.drawAlpha.toString();

    }

    stagePhoto2DrawRewind() {
if(this.photo.className === "hidden")
this.photo.className = "";

        this.drawAlpha -= this.speed;

        if (this.drawAlpha <= 0.0) {
            this.drawAlpha = 0.0;
this.draw.className = "hidden";
            this.next = true;
        }

        this.photoAlpha = 1.0 - this.drawAlpha;
        this.photo.style.opacity = this.photoAlpha.toString();
        this.draw.style.opacity = this.drawAlpha.toString();
    }

    stagePhoto2EndingForward() {
if(this.draw.className === "hidden")
this.draw.className = "";
        this.drawAlpha += this.speed;

        if (this.drawAlpha >= 1.0) {
            this.drawAlpha = 1.0;
this.photoAlpha = 0.0;
this.photo.className = "hidden";
            this.next = true;
        }

        this.photoAlpha = 1.0 - this.drawAlpha;
        this.photo.style.opacity = this.photoAlpha.toString();
        this.draw.style.opacity = this.drawAlpha.toString();

    }


    stageDraw() {
        this.ttl += this.speed;
        if (this.ttl >= 1.0)
            this.next = true;
    }

    stageDraw2StopForward() {
        this.drawAlpha -= this.speed;

        if (this.drawAlpha <= 0.0) {
            this.drawAlpha = 0.0;
this.draw.className = "hidden";
            this.next = true;
        }

        this.draw.style.opacity = this.drawAlpha.toString();
    }

    stageDraw2StopRewind() {
if(this.photo.className === "hidden")
this.photo.className = "";
        this.drawAlpha -= this.speed;
        if (this.drawAlpha >= 0.0)
            this.draw.style.opacity = this.drawAlpha.toString();
        if (this.drawAlpha < 0.0) {
            this.drawAlpha = 0.0;
this.draw.className = "hidden";
        }
        this.photoAlpha += this.speed;
        if (this.photoAlpha >= 1.0) {
            this.photoAlpha = 1.0;
            this.drawAlpha = 0.0;
            this.next = true;
        }

        this.photo.style.opacity = this.photoAlpha.toString();
    }

}
